// Generated by CoffeeScript 1.7.1
(function() {
  var FakeWindow, ipc, process, remote,
    __slice = [].slice;

  process = global.process;

  ipc = require('ipc');

  remote = require('remote');

  FakeWindow = (function() {
    function FakeWindow(guestId) {
      this.guestId = guestId;
    }

    FakeWindow.prototype.close = function() {
      return ipc.send('ATOM_SHELL_GUEST_WINDOW_MANAGER_WINDOW_CLOSE', this.guestId);
    };

    FakeWindow.prototype.focus = function() {
      return ipc.send('ATOM_SHELL_GUEST_WINDOW_MANAGER_WINDOW_METHOD', this.guestId, 'focus');
    };

    FakeWindow.prototype.blur = function() {
      return ipc.send('ATOM_SHELL_GUEST_WINDOW_MANAGER_WINDOW_METHOD', this.guestId, 'blur');
    };

    FakeWindow.prototype["eval"] = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return ipc.send.apply(ipc, ['ATOM_SHELL_GUEST_WINDOW_MANAGER_WEB_CONTENTS_METHOD', this.guestId, 'executeJavaScript'].concat(__slice.call(args)));
    };

    return FakeWindow;

  })();

  if (process.guestInstanceId == null) {
    window.close = function() {
      return remote.getCurrentWindow().close();
    };
  }

  window.open = function(url, frameName, features) {
    var feature, guestId, name, options, value, _i, _len, _ref, _ref1;
    if (frameName == null) {
      frameName = '';
    }
    if (features == null) {
      features = '';
    }
    options = {};
    _ref = features.split(',');
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      feature = _ref[_i];
      _ref1 = feature.split('='), name = _ref1[0], value = _ref1[1];
      options[name] = value === 'yes' ? true : value === 'no' ? false : value;
    }
    if (options.x == null) {
      options.x = options.left;
    }
    if (options.y == null) {
      options.y = options.top;
    }
    if (options.title == null) {
      options.title = name;
    }
    if (options.width == null) {
      options.width = 800;
    }
    if (options.height == null) {
      options.height = 600;
    }
    guestId = ipc.sendSync('ATOM_SHELL_GUEST_WINDOW_MANAGER_WINDOW_OPEN', url, frameName, options);
    return new FakeWindow(guestId);
  };

  window.alert = function(message, title) {
    var buttons, dialog;
    if (title == null) {
      title = '';
    }
    dialog = remote.require('dialog');
    buttons = ['OK'];
    return dialog.showMessageBox(remote.getCurrentWindow(), {
      message: message,
      title: title,
      buttons: buttons
    });
  };

  window.confirm = function(message, title) {
    var buttons, dialog;
    if (title == null) {
      title = '';
    }
    dialog = remote.require('dialog');
    buttons = ['OK', 'Cancel'];
    return !dialog.showMessageBox(remote.getCurrentWindow(), {
      message: message,
      title: title,
      buttons: buttons
    });
  };

  window.prompt = function() {
    throw new Error('prompt() is and will not be supported in atom-shell.');
  };

}).call(this);
